// ---------------------------------------------------------------------------
//
//               COMMON STRUCTURES USED BY:  VIDEO_TS.IFO
//                                           VTS_XX_X.IFO
//
//              (P)2007 - FSL FreeSoftLand - http://fsl.sytes.net
//
// ---------------------------------------------------------------------------
unit Structure_Common;

interface

Type

  // --------------------------------------------------------------------------
  // used by  VMG: VMGI_MAT
  //          VTS: VTSI_MAT
  // --------------------------------------------------------------------------

  Version_number = record
    Reserved:                      Byte;                                        // Reserved (default: 0)
    Major_Minor:                   Byte;                                        // Versione, 4 + 4 bit
      // D7..D4:                     4 bit;                                     //   Major version
      // D3..D0:                     4 bit;                                     //   Minor version
  end;

  VMG_Category = record
    Prohibited_Region_Mask:        Byte;                                        // Prohibited Region Mask
    Regional_Code_Mask:            Byte;                                        // Regional Code mask Region (xx654321)
    Category:                      Word;                                        // VMG Category
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_VOBS
  //          VTS: VTSM_VOB
  //          VTS: VTS_VOB
  // --------------------------------------------------------------------------

  Video_attributes = record
    VidMode:                       Byte;                                        // Video mode:
      // D7..D6:                     2 Bit;                                     //   Coding mode: 0=MPEG-1, 1=MPEG-2
      // D5..D4:                     2 Bit;                                     //   Standard: 0=NTSC, 1=PAL
      // D3..D2:                     2 Bit;                                     //   Aspect: 0=4:3, 1=not specified, 2=reserved, 3=16:9
      // D1:                         1 Bit;                                     //   Automatic Pan/Scan: 1=disallowed
      // D0:                         1 Bit;                                     //   Automatic Letterbox: 1=disallowed
    VidFormat:                     Byte;                                        // Video format:
      // D7:                         1 Bit;                                     //   CC for line 21 field 1 in GOP (solo NTSC)
      // D6:                         1 Bit;                                     //   CC for line 21 field 2 in GOP (solo NTSC)
      // D5:                         1 Bit;                                     //   Not used
      // D4:                         1 Bit;                                     //   BitRate: 0=VBR, 1=CBR
      // D3..D2:                     2 Bit;                                     //   Resolution NTSC(PAL): 0=720x480(720x576), 1=704x480(704x576),
                                                                                //                         2=352x480(352x576), 3=352x240(352x288)
      // D1:                         1 Bit;                                     //   Letterbox: 1=top and bottom cropper
      // D0:                         1 Bit;                                     //   Film: 0=camera, 1=film (PAL only)
  end;

  Audio_attributes = record
    AudMode:                       Byte;                                        // Audio mode:
      // D7..D5:                     3 Bit;                                     //   Coding mode: 0=AC3, 2=MPEG-1, 3=MPEG-2ext, 4=LPCM, 6=DTS (1,5,7=???)
      // D4:                         1 Bit;                                     //   Multichannel extension: 1=present
      // D3..D2:                     2 Bit;                                     //   Language type: 0=unspecified, 1=(Char1+Char2)
      // D1..D0:                     2 Bit;                                     //   Application Mode: 0=unspecified, 1=karaoke, 2=surround
    AudFormat:                     Byte;                                        // Audio format:
      // D7..D6:                     2 Bit;                                     //   Quantization/DRC: 0=16 bps, 1=20 bps, 2=24 bps,
                                                                                //                     3=DRC (Dynamic Range Control)
      // D5..D4:                     2 Bit;                                     //   SampleRate: 0=48 Kbps
      // D3:                         1 Bit;                                     //   Reserved
      // D2..D0:                     3 Bit;                                     //   Channels-1
    Char1:                         Byte;                                        // first character of language code
    Char2:                         Byte;                                        // second character of language code
    Reserved:                      Byte;                                        // reserved for language code extension
    Code_extension:                Byte;                                        // Code extension: 0=unspecified, 1=normal, 2=visually impaired,
                                                                                //                 3=director's comments,   4=alternate director's comm.
    Reserved2:                     Byte;                                        // not used
    App_information:               Byte;                                        // Application information (Karaoke mode/surround mode):
      // Karaoke mode:
      // D7:                         1 Bit;                                     //   Not used (default: 0)
      // D6..D4:                     3 Bit;                                     //   Channel assignments: 0=1+1,          1=1/0,           2=2/0L,R,
                                                                                //                        3=3/0L,M,R,     4=2/1L,R,V1,     5=3/1L,M,R,V1,
                                                                                //                        6=2/2L,R,V1,V2, 7=3/2L,M,R,V1,V2
      // D3..D2:                     2 Bit;                                     //   Karaoke version
      // D1:                         1 Bit;                                     //   MC Intro present
      // D0:                         1 Bit;                                     //   0=solo, 1=duet
      // Surround mode:
      // D7..D4:                     4 Bit;                                     //   Reserved
      // D3:                         1 Bit;                                     //   1=compatibile dolby surround decoding
      // D2..D0:                     3 Bit;                                     //   Reserved
  end;

  Multichannel_extension = record                                               // Multichannel extension (Karaoke Mode)
    ACH0:                          Byte;                                        // ACH0:
      // D7..D1:                     7 Bit;                                     //   Reserved
      // D0:                         1 Bit;                                     //   1=guide melody exists
    ACH1:                          Byte;                                        // ACH1:
      // D7..D1:                     7 Bit;                                     //   Reserved
      // D0:                         1 Bit;                                     //   1=guide melody exists
    ACH2:                          Byte;                                        // ACH2:
      // D7..D4:                     4 Bit;                                     //   Reserved
      // D3:                         1 Bit;                                     //   1=guide vocal 1 exists
      // D2:                         1 Bit;                                     //   1=guide Vocal 2 exists
      // D1:                         1 Bit;                                     //   1=guide melody 1 exists
      // D0:                         1 Bit;                                     //   1=guide melody 2 exists
    ACH3:                          Byte;                                        // ACH3:
      // D7..D4:                     4 Bit;                                     //   Reserved
      // D3:                         1 Bit;                                     //   1=guide vocal 1 exists
      // D2:                         1 Bit;                                     //   1=guide Vocal 2 exists
      // D1:                         1 Bit;                                     //   1=guide melody A exists
      // D0:                         1 Bit;                                     //   1=guide sound effects A exists
    ACH4:                          Byte;                                        // ACH4:
      // D7..D4:                     4 Bit;                                     //   Reserved
      // D3:                         1 Bit;                                     //   1=guide vocal 1 exists
      // D2:                         1 Bit;                                     //   1=guide Vocal 2 exists
      // D1:                         1 Bit;                                     //   1=guide melody B exists
      // D0:                         1 Bit;                                     //   1=guide sound effects B exists
    Reserved:                      array[0..18] of Byte;                        // not used
  end;

  Subp_stream_attributes = record
    SubpMode:                      Byte;                                        // Coding Mode, Language Type
    Reserved_001:                  Byte;
    Char1:                         Byte;                                        // first character of language code
    Char2:                         Byte;                                        // second character of language code
    Reserved_002:                  Byte;                                        // reserved for language code extension
    Code_extension:                Byte;                                        // Normal, Comments, Large, ecc...
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: PTT_SRPTI
  //          VTS: PTT_SRPTI
  // --------------------------------------------------------------------------

  PTT = record                                                                  // Program Title Table:
    Program_Chain_number_PGCN:     Word;                                        // Program Chain number PGCN
    Program_number_PG:             Word;                                        // Program number PG
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_PGCI_UT
  //          VTS: VTS_PGCITI
  //          VTS: VTSM_PGCI_UT
  // --------------------------------------------------------------------------

  PGCI = record                                                                 // Program Chain Information:
    Category_mask:                 Byte;                                        // PGC_Category mask:
      // D7:                         1 Bit;                                     //   1=entry PGC
      // D6..D0:                     7 Bit;                                     //   Title number
    Category:                      Byte;                                        //
    Category_Parental_ID_mask:     Word;                                        // Category Parental ID mask
    PGC_start_byte:                LongWord;                                    // PGCI start byte (offset)
  end;

  // --------------------------------------------------------------------------
  // used by  PGC
  // --------------------------------------------------------------------------

  ASt = record                                                                  // Audio stream status:
    Control:                       Byte;
      // D7:                         1 Bit;                                     //   1=stream available
      // D6..D3:                     4 Bit;                                     //   Reserved
      // D2..D0:                     3 Bit;                                     //   Stream number (if MPEG audio) or Substream number (all others)
    Reserved:                      Byte;                                        // Reserved
  end;

  SSt = record                                                                  // Sub-picture stream status
    Control_1:                     Byte;
      // D7:                         1 Bit;                                     //   1=stream available
      // D6..D5:                     2 Bit;                                     //   Reserved
      // D4..D0:                     5 Bit;                                     //   Stream number (4:3)
    Control_2:                     Byte;
      // D7..D5:                     3 Bit;                                     //   Reserved
      // D4..D0:                     5 Bit;                                     //   Stream number (Wide)
    Control_3:                     Byte;
      // D7..D5:                     3 Bit;                                     //   Reserved
      // D4..D0:                     5 Bit;                                     //   Stream number (LetterBox)
    Control_4:                     Byte;
      // D7..D5:                     3 Bit;                                     //   Reserved
      // D4..D0:                     5 Bit;                                     //   Stream number (Pan&Scan)
  end;

  ColorP = record
    Unused:                        Byte;                                        // =0
    Y:                             Byte;                                        // Y
    Cr:                            Byte;                                        // Cr
    Cb:                            Byte;                                        // Cb
  end;

  Commands = record
    Command:                       array[0..7] of Byte;                         // 8 bytes for command
  end;

  Cell_PlayBack_Info = record
    Category_1:                    Byte;
      // D7..D6:                     2 Bit;                                     //  cell type: 00=normal, 01=first of angle block,
                                                                                //                        10=middle of angle block,
                                                                                //                        11=last of angle block
      // D5..D4:                     2 Bit;                                     //  Block Type: 00=normal, 01=angle block
      // D3:                         1 Bit;                                     //  1=seamless playback linked in PCI
      // D2:                         1 Bit;                                     //  1=interleaved
      // D1:                         1 Bit;                                     //  1=STC discontinuity
      // D0:                         1 Bit;                                     //  1=seamless angle linked in DSI
    Category_2:                    Byte;
      // D7:                         1 Bit;                                     //   Reserved (0)
      // D6:                         1 Bit;                                     //   1 = restricted (stops trick play)
      // D5..D0:                     6 Bit;                                     //   Reserved  (0)
    still_time:                    Byte;                                        // still time (seconds, 255=infinite)
    command_Nr:                    Byte;                                        // command Nr (0 = no command)
    playback_time:                 LongWord;                                    // playback time:
      // Byte_1:                     Byte;                                      //   BCD: hh
      // Byte_2:                     Byte;                                      //   BCD: mm
      // Byte_3:                     Byte;                                      //   BCD: ss
      // Byte_4:                     Byte;                                      //   BCD: ff - framerate: 11 = 30 fps, 10 = illegal,
                                                                                //                        01 = 25 fps, 00 = illegal
    entry_point_sector:            LongWord;                                    // entry point sector
    first_ILVU_VOBU_end_sector:    LongWord;                                    // first ILVU VOBU end sector
    start_sector_of_last_VOBU:     LongWord;                                    // start sector of last VOBU
    last_sector_of_this_cell:      LongWord;                                    // last sector of this cell
  end;

  Cell_Position_Info = record
    VOB_id:                        Word;                                        // VOB id
    Reserved:                      Byte;                                        // Reserved
    Cell_id:                       Byte;                                        // Cell id
  end;


  // --------------------------------------------------------------------------
  // used by  VMG: FP_PGC
  //          VTS: VTS_PGCITI
  // --------------------------------------------------------------------------

  PGC = record                                                                  // (ProGram Chain)
    // PGC header:
    Unused:                        Word;                                        // [0-1]     --
    Number_of_Programs:            Byte;                                        // [2]       Number of Programs
    Number_of_Cells:               Byte;                                        // [3]       Number of Cells
    Playback_time:                 LongWord;                                    // [4-7]     Playback time
    Prohibited_user_ops:           LongWord;                                    // [8-11]    Prohibited user operations
    PGC_AST_CLT:                   array[0..7] of ASt;                          // 12-27]    Array of Audio stream (n) status
    PGC_SST_CLT:                   array[0..31]of SSt;                          // 28-155]   Array of Sub-picture stream (n) status
    Next_PGC_number:               Word;                                        // [156-157] Next PGC number
    Previous_PGC_number:           Word;                                        // [158-159] Previous PGC number
    GoUp_PGC_number:               Word;                                        // [160-161] Go Up PGC number
    Still_time:                    Byte;                                        // [162]     Still time in seconds (255=infinite)
    PG_Playback_mode:              Byte;                                        // [163]	   0=sequential, or: bit7=random (0) or shuffle (1),
                                                                                //           and program count in bits 6-0
    Palette:                       array[0..15] of ColorP;                      // [164-227] Palette (16 colors)
    Offs_PGC_Command_Table:        Word;                                        // [228-229] PGC Command Table start byte
    Offs_PGC_Program_Map:          Word;                                        // [230-231] PGC Program Map start byte
    Offs_Cell_Playback_ITable:     Word;                                        // [232-233] Cell Playback Information Table start byte
    Offs_Cell_Position_ITable:     Word;                                        // [234-235] Cell Position Information Table start byte
    // Command Table
    Number_of_Pre_Commands:        Word;                                        // [0-1]     Number of Pre Commands
    Number_of_Post_Commands:       Word;                                        // [2-3]     Number of Post Commands
    Number_of_Cell_Commands:       Word;                                        // [4-5]     Number of Cell Commands
    end_address_relative:          Word;                                        // [6-7]     End address relative to command table
    Pre:                           array of Commands;                           //           Pre Commands table
    Post:                          array of Commands;                           //           Pre Commands table
    Cell:                          array of Commands;                           //           Pre Commands table
    // Program Map
    Program_Map:                   array of Byte;                               // (Number_of_Programs) bytes, pad to word boundary with zero
    // Cell Playback information
    Cell_PlayBack_Information:     array of Cell_PlayBack_Info;                 // (one per cell)
    // Cell Position (VOBind & CELLind)
    Cell_Position_Information:     array of Cell_Position_Info;                 // (one per cell)
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_PGCI_UT
  //          VTS: VTSM_PGCI_UT
  // --------------------------------------------------------------------------

  PGCI_LUI = record
    Menu_Language_Code:            Word;                                        // (ISO 639)	Menu Language Code
    Reserved:                      Byte;                                        // Reserved for language code extension
    Menu_Existence_mask:           Byte;                                        // Menu Existence mask:
      // D7:                         1 Bit;                                     //   1=Root (other bits must be ignored)
      // D6:                         1 Bit;                                     //   1=Sub-picture menu (other bits must be ignored)
      // D5:                         1 Bit;                                     //   1=Audio menu (other bits must be ignored)
      // D4:                         1 Bit;                                     //   1=Angle menu (other bits must be ignored)
      // D3:                         1 Bit;                                     //   1=PTT menu (other bits must be ignored)
      // D2..D0:                     3 Bit;                                     //   not used
    PGCI_LU_start_byte:            LongWord;                                    // PGCI Language Unit start byte
  end;

  PGCI_LU_EA = record
    Category_Menu_Mask:            Byte;                                        // PGC category menu mask
      //D7:                          1 Bit;                                     //   1=Entry PGC & D3..D0 valids
      //D6..D4:                      3 Bit;                                     //   Reserved
      //D3..D0:                      4 Bit;                                     //   Menu Type: 3=root, 4=sub-picture, 5=audio, 6=angle, 7=PTT (chapter)
    Category:                      Byte;                                        // Category
    Category_Parental_Id_Mask:     Word;                                        // Category parental id mask
    PGC_start_byte:                LongWord;                                    // PGCI start byte (offset)
  end;

  PGCI_LU = record                                                              // Language Unit:
    PGCI_SRP:                      Word;                                        // Number of menu's for this LU
    Unused:                        Word;                                        // not used
    End_byte_of_LU_EA:             LongWord;                                    // End byte of LU_EA table
    LU_EA_array:                   array of PGCI_LU_EA;                         // Array of LU_EA
    PGC_array:                     array of PGC;                                // array of program chains
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMG_TXTDT_MG
  // --------------------------------------------------------------------------

  TXTDT_LUI = record                                                            // Language Unit Index:
    Menu_Language_Code:            Word;                                        // (ISO 639)	Menu Language Code
    Unknown:                       Word;                                        // Possible numbers of text data's
    TXTDT_LU_start_byte:           LongWord;                                    // Text Data Language Unit start byte
  end;

  TXTDT_LU = record                                                             // Language Unit:
    End_byte_of_TXTDT_LU:          LongWord;                                    // End byte of TXTDT_LU table
    Unknown_001:                   Word;                                        // Char set code?
    Unknown_002:                   Word;                                        // Char set code?
    Unknown_003:                   array[0..195] of byte;                       // 196 unknown bytes
    Number_of_entries:             Word;                                        // Numbers of Entries
    Reserved:                      Word;                                        // Reserved word
    TXTDT:                         array of array[0..3] of byte;                // Array of 4 bytes entries (??)
    TXT:                           array of char;                               // Text (to end of table)
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMG_TT_SRPT
  // --------------------------------------------------------------------------

  TT = record
    Title_Type:                    Byte;                                        // title type
      // D7:                         1 Bit;                                     //   Reserved
      // D6:                         1 Bit;                                     //   0=one_sequential_pgc 1=not one_sequential (random, shuffle, stills,
                                                                                //                          loops, or more than one pgc)
      // D5..D2:    D5 cell          4 Bit;                                     //   Jump/Link/Call commands:
      //            D4 pre/post                                                 //   0000 None              0001 invalid              0011 only in button
      //            D3 button                                                   //   0101 only in pre/post  0111 in button & pre/post 1001 only in cell
      //            D2 exist                                                    //   1011 in cell & button  1101 in cell & pre/post   1111 in all places
      // D1:                         1 Bit;                                     //   (Uop1) PTT play or search
      // D0:                         1 Bit;                                     //   (Uop0) Time play or search
    Number_of_angles:              Byte;                                        // Number of angles
    Number_of_chapters:            Word;                                        // number of chapters (PTTs)
    Parental_management_mask:      Word;                                        // Parental management mask
    Video_Title_Set_number:        Byte;                                        // Video Title Set number, VTSN
    Title_number:                  Byte;                                        // Title number within VTS, VTS_TTN
    Start_sector_for_VTS:          LongWord;                                    // start sector for VTS, referenced to whole disk (video_ts.ifo starts
                                                                                //                                                 at sector 00000000)
  end;

  // --------------------------------------------------------------------------
  // used by  VTS: VTS_TMAPTI
  // --------------------------------------------------------------------------

  TMAP = record
    Time_unit:                     Byte;                                        // time unit (seconds)
    Reserved:                      Byte;                                        // reserved
		Number_of_entries_in_TMAP:     Word;                                        // number of entries in time map (0=empty)
    TMAP_sector:                   array of LongWord;                           // Sector offset withing VOBS of nearest VOBU
  end;                                                                          // - bit 31 set if VOBU time codes are discontinuos with previous

  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_C_ADT
  //          VTS: VTSM_C_ADT
  //          VTS: VTS_C_ADT
  // --------------------------------------------------------------------------

  C_AD = record                                                                 // Cel address table:
    VOB_ID:                        Word;                                        // VOB ID
    Cell_ID:                       Byte;                                        // Cell ID
    Reserved:                      Byte;                                        //
    Start_sector:                  LongWord;                                    // Start sector del VOB
    End_sector:                    LongWord;                                    // End sector del VOB
  end;

  C_ADT = record
    Number_of_cells:               Word;                                        // Number of VOB cells
    Unused:                        Word;                                        //
    End_byte_of_table:             LongWord;                                    // End byte of table
    C_AD_array:                    array of C_AD;                               // C_AD_array[n]: Cel address tables
  end;


  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_VOBU_ADMAP
  //          VTS: VTSM_VOBU_ADMAP
  //          VTS: VTS_VOBU_ADMAP
  // --------------------------------------------------------------------------

  VOBU_ADMAP = record
    End_byte_of_table:               LongWord;                                  // End byte of VOBU_ADMAP table
    VOBU_start_sector_array:         array of LongWord;                         // VOBU_start_sector_array[n]: Array of VOBU[n] start sector
  end;


  // --------------------------------------------------------------------------
  // used by  VMG: VMG_PTL_MAIT
  // --------------------------------------------------------------------------

  Country_Codes = record
    Country_Code:                  Word;                                        // Country code
    PTL_MAIT_start_byte:           LongWord;                                    // Parental Management Tables start byte
    Reserved:                      Word;                                        // PADDING BYTES (2)
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMGM_VOBS
  //               ATRT
  //          VTS: VTSM_VOB
  //               VTS_VOB
  // --------------------------------------------------------------------------

  Menu_VOB = record
    Video_attributes_of_VOBS:      Video_attributes;                            // [  2] Video attributes of VTSM_VOBS
    Audio_streams_in_VOBS:         Word;                                        // [  2] Number of audio streams in VTSM_VOBS
    Audio_attributes_array:        Array[0..7] of Audio_attributes;             // [ 64] VTSM audio (8) attributes list
    Unused_001:                    Array[0..15] of Byte;                        // [ 16] PADDING BYTES (16)
    Reserved:                      Byte;                                        // [  1] Padding to word for next byte
    Number_of_Subp_streams:        Byte;                                        // [  1] Number of Sub-picture streams in VTSM
    sSubp_stream_attributes:       Subp_stream_attributes;                      // [  6] VTSM sub-picture (6) attributes
    Unused_002:                    Array[0..163] of Byte;                       // [164] PADDING BYTES (164) per arrivare a 256 ($100)
  end;

  Title_VOB = record
    Video_attributes_of_VOBS:      Video_attributes;                            // [  2] Video attributes of VTSTT_VOBS
    Audio_streams_in_VOBS:         Word;                                        // [  2] Number of audio streams in VTSTT_VOBS
    Audio_attributes_array:        Array[0..7] of Audio_attributes;             // [ 64] Audio (8) attributes list
    Unused_001:                    Array[0..15] of Byte;                        // [ 16] PADDING BYTES (16)
    Subp_streams_in_VOBS:          Word;                                        // [  2] Number of sub-picture streams in VTSTT_VOBS
    Subp_stream_attributes_array:  Array[0..31] of Subp_stream_attributes;      // [192] Sub-picture stream (6) attributes list
    Unused_002:                    Word;                                        // [  2] PADDING BYTES (2)
    Multichannel_extension_array:  Array[0..7] of Multichannel_extension;       // [192] Multichannel extension (24)
    Unused_003:                    Array[0..39] of Byte;                        // [ 40] PADDING BYTES (40) per arrivare a 512 ($200)
  end;

  // --------------------------------------------------------------------------
  // used by  VMG: VMG_VTS_ATRT
  // --------------------------------------------------------------------------

  ATRT = record                                                                 // Video Title-Set Attribute Table:
    End_byte_of_ATRT:              LongWord;                                    // [  4] End byte of Attribute Table (length of table - 1)
    Application_Type:              LongWord;                                    // [  4] Application Type
    sMenu_VOB:                     Menu_VOB;                                    // [256] Copy of video attributes of VTSM_VOB
    sTitle_VOB:                    Title_VOB;                                   // [512] Copy of video attributes of VTS_VOB
  end;

implementation

end.
